public class GameInfo
{
	private int numberOfPlayers;		// How many players
	private String [] playerNicks;		// All players nicks
	private String [] playerPW;			// All players Passwords
	private int [][][] history;			// War history
	private int [][] currentTurnInformation; // All information for current turn
	
	// -------------- history -----------------------
	// First row: PlayerIndex (All players)									- The player, who's history we want to view
	// Second row: PlayerIndex (All players)								- The enemy to the player
	// Third row: # of people nuked/bombed, # of people left by propaganda	- For each enemy
	
	
	// -------------- currentTurnInformation --------
	// playerIndex, citySize (1 to 5), orderNumber, numberOfSpies, 
	// numberOfNukes(level 1), numberOfNukes(level 2), numberOfNukes(level 3), numberOfNukes(level 4), 
	// numberOfBombers(level 1), numberOfBombers(level 2), 
	// numberOfDefense(level 1), numberOfDefense(level 2)
	
	/**
	 * Constructor
	 **/
	
	public GameInfo(int numberOfPlayers, String [] playerNicks, String [] playerPW, int [][] currentTurnInformation, int [][][] history)
	{
		this.numberOfPlayers = numberOfPlayers;
		this.playerNicks = playerNicks;
		this.playerPW = playerPW;
		this.history = history;
		this.currentTurnInformation = currentTurnInformation;
	}
	
	/**
	 * Constructor - new game
	 **/
	 
	 public GameInfo(int numberOfPlayers, String [] playerNicks, String [] playerPW)
	 {
		this.numberOfPlayers = numberOfPlayers;
		this.playerNicks = playerNicks;
		this.playerPW = playerPW;
		this.history = new int [numberOfPlayers][numberOfPlayers][2];
		this.currentTurnInformation = new int [numberOfPlayers][17];
	 }
	 
	/**
	 * Constructor - empty variables
	 **/
	  
	public GameInfo(int numberOfPlayers)
	{
		this.numberOfPlayers = numberOfPlayers;
		this.playerNicks = new String [numberOfPlayers];
		this.playerPW = new String [numberOfPlayers];
		this.history = new int [numberOfPlayers][numberOfPlayers][2];
		this.currentTurnInformation = new int [numberOfPlayers][17];
	}
	
	/**
	 * Returns the number of players
	 * @return The number of players
	 **/
	
	public int getNumberOfPlayers()
	{
		return numberOfPlayers;
	}
	
	/**
	 * Returns the player nick, from index number
	 * @param playerIndex - Index for player
	 * @return Nick for player
	 **/
	
	public String getPlayerNick(int playerIndex)
	{
		return playerNicks[playerIndex];
	}
	
	/**
	 * Returns a PW for the player
	 * @param playerIndex - Index for player
	 * @return The password for player
	 **/
	 
	public String getPlayerPW(int playerIndex)
	{
		return playerPW[playerIndex];
	}
	
	/**
	 * Returns the selected players history against selected enemy
	 * @param historyType - What history amount should be returned:
	 * 0 = Amount citizens lost to bombing/nuking
	 * 1 = Amount citizens lost to propaganda
	 * @return The selected history
	 **/
	
	public int getHistory(int playerIndex, int enemyIndex, int historyType)
	{
		return history[playerIndex][enemyIndex][historyType];
	}
	
	/**
	 * Returns the selected player information for current turn
	 * @param playerIndex - Index of selected player
	 * @param informationType - What information should be extracted
	 * @return Current turn information for selected player
	 **/
	
	public int getCurrentTurnInformation(int playerIndex, int informationType)
	{
		return currentTurnInformation[playerIndex][informationType];
	}
	
	/**
	 * Set the nickname for selected player
	 * @param playerIndex - Index of player
	 * @param playerNick - New nickname for selected player
	 **/
	
	public void setPlayerNick(int playerIndex, String playerNick)
	{
		this.playerNicks[playerIndex] = playerNick;
	}
	
	/**
	 * Sets the PassWord for selected player
	 * @param playerIndex - Index of player
	 * @param playerPW - PassWord for selected player
	 **/
	
	public void setPlayerPW(int playerIndex, String playerPW)
	{
		this.playerPW[playerIndex] = playerPW;
	}
	
	/**
	 * Changes a history value, for selected player, towards a selected enemy
	 * @param playerIndex - Index of player
	 * @param enemyIndex - Index of player's enemy
	 * @param historyType - What history type (Bombing/Nuking or propaganda) should be changed
	 * @param value - Value it should be changed to
	 **/
	
	public void setHistory(int playerIndex, int enemyIndex, int historyType, int value)
	{
		this.history[playerIndex][enemyIndex][historyType] = value;
	}
	
	/**
	 * Sets an information for selected player, for current turn
	 * @param playerIndex - Index of player
	 * @param informationType - What type of current turn information should be changed
	 * @param value - To what what should this information be set to
	 **/
	
	public void setCurrentTurnInformation(int playerIndex, int informationType, int value)
	{
		System.out.println("player: " + playerIndex + " InformationType: " + informationType + " value: " + value);
		this.currentTurnInformation[playerIndex][informationType] = value;
	}
	
	public int findPlayer(String playerNick)
	{
		for(int i = 0; i < numberOfPlayers; i++)
			if(playerNicks[i].equals(playerNick))
				return i;
		
		return -1;
	}
	
	/**
	 * TEMP
	 * To see if all information has been saved/loaded correctly
	 **/

	public void printGameInfo()
	{
		System.out.println("Player nicks:\t");
		for(int i = 0; i < numberOfPlayers; i++)
			System.out.println(playerNicks[i]+"\t");
			
		System.out.println("\n\nPlayer PWs:\t");
		for(int i = 0; i < numberOfPlayers; i++)
			System.out.println(playerPW[i]+"\t");
	}
	
}